<xsl:stylesheet version = "2.0" 
   xmlns:xsl = "http://www.w3.org/1999/XSL/Transform">  
<xsl:template match = "/report">
pilotsobj["<xsl:value-of select = "pilot/@id"/>"] = {
 "contest_name":"<xsl:value-of select = "contest_name"/>",
 "type":"<xsl:value-of select = "type"/>",
 "timestamp":"<xsl:value-of select = "timestamp"/>",
 "pilot_name":"<xsl:value-of select = "pilot/name"/>",
 "pilot_id":"<xsl:value-of select = "pilot/@id"/>",
 "pilot_address1":"<xsl:value-of select = "pilot/address1"/>",
 "pilot_address2":"<xsl:value-of select = "pilot/address2"/>",
 "pilot_airplane":"<xsl:value-of select = "pilot/airplane"/>",
 "pilot_mpp":"<xsl:value-of select = "pilot/missing_pilot_panel"/>",
 "pilot_active":"<xsl:value-of select = "pilot/active"/>",
 "pilot_freestyle":"<xsl:value-of select = "pilot/freestyle"/>",
 "pilot_class":"<xsl:value-of select = "pilot/class/@type"/>",
 "pilot_frequency":"<xsl:value-of select = "pilot/frequency"/>",
 "pilot_ama_number":"<xsl:value-of select = "pilot/ama_number"/>",
 "pilot_imac_number":"<xsl:value-of select = "pilot/imac_number"/>",
 "sections":[
  <xsl:for-each select = "section"> 
  { "type":"<xsl:value-of select = "@type"/>",
    "start_round":"<xsl:value-of select = "@start_round"/>",
    "end_round":"<xsl:value-of select = "@end_round"/>",
    "judge_sheet":"<xsl:value-of select = "@judge_sheet"/>",
    "flights":[
      <xsl:for-each select = "flight">
      { "round":"<xsl:value-of select = "@round"/>","sequence":"<xsl:value-of select = "@sequence"/>","ksum":"<xsl:value-of select = "@ksum"/>",<xsl:if test="@penalty">"penalty":"<xsl:value-of select = "@penalty"/>",</xsl:if>"score":"<xsl:value-of select = "@score"/>",<xsl:if test="@non_scale_penalty">"mpp":"<xsl:value-of select = "@non_scale_penalty"/>",</xsl:if>
        "figures":[<xsl:for-each select = "figure">
        { "index":"<xsl:value-of select = "@index"/>","desc":"<xsl:value-of select = "desc"/>","k_factor":"<xsl:value-of select = "k_factor"/>",<xsl:if test="box_flag">"box_flag":"<xsl:value-of select = "box_flag"/>",</xsl:if><xsl:if test="not_observed_flag">"not_observed_flag":"<xsl:value-of select = "not_observed_flag"/>",</xsl:if><xsl:if test="break_flag">"break_flag":"<xsl:value-of select = "break_flag"/>",</xsl:if><xsl:if test="comment">"comment":"<xsl:value-of select = "comment"/>",</xsl:if>"score":"<xsl:value-of select = "score"/>" }<xsl:if test="position() != last()">,</xsl:if></xsl:for-each>
        ]
      }<xsl:if test="position() != last()">,</xsl:if>
      </xsl:for-each>
    ]
  }<xsl:if test="position() != last()">,</xsl:if>
  </xsl:for-each> 
  ]
}
</xsl:template>  
</xsl:stylesheet>