<xsl:stylesheet version = "2.0" 
   xmlns:xsl = "http://www.w3.org/1999/XSL/Transform">  
<xsl:template match = "/report">
results3obj = {
 "type":"<xsl:value-of select = "type"/>",
 "name":"<xsl:value-of select = "contest_name"/>",
 "timestamp":"<xsl:value-of select = "timestamp"/>",
 "region":"<xsl:value-of select = "region"/>",
 "sections":[
  <xsl:for-each select = "section"> 
  { "class":"<xsl:value-of select = "@class"/>",
    "rows":[
      <xsl:for-each select = "row">
      {
        "name":"<xsl:value-of select = "pilot/name"/>",
        "id":"<xsl:value-of select = "pilot/@id"/>",
        "s_perc":"<xsl:value-of select = "final_score/@perc"/>",
        "s_scaled":"<xsl:value-of select = "final_score"/>",
        "s_percknown":"<xsl:value-of select = "final_score/@percknown"/>",
        "s_percunknown":"<xsl:value-of select = "final_score/@percunknown"/>",
        "points":"<xsl:value-of select = "points"/>",
        "rank":"<xsl:value-of select = "@rank"/>",
        "index":"<xsl:value-of select = "@index"/>",
        "scores":[
        <xsl:for-each select = "score">
        { "type":"<xsl:value-of select = "@type"/>",
          "round":"<xsl:value-of select = "@round"/>",
          "sequence":"<xsl:value-of select = "@sequence"/>",
          "thrown":"<xsl:value-of select = "@thrown"/>",
          "percthrown":"<xsl:value-of select = "@percthrown"/>",
          "s_perc":"<xsl:value-of select = "@perc"/>",
          "s_scaled":"<xsl:value-of select = "current()"/>" }<xsl:if test="position() != last()">,</xsl:if></xsl:for-each>
        ]
      }<xsl:if test="position() != last()">,</xsl:if>
      </xsl:for-each>
    ]
  }<xsl:if test="position() != last()">,</xsl:if>
  </xsl:for-each> 
  ]
}
</xsl:template>  
</xsl:stylesheet>